/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.stateproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4651;
import net.minecraft.class_4652;
import net.minecraft.class_5216;
import net.minecraft.class_5863;
import net.minecraft.class_5866;
import net.minecraft.class_6579;
import potionstudios.byg.common.world.feature.stateproviders.BYGStateProviders;

public class BetweenNoiseThresholdProvider
extends class_6579 {
    public static final Codec<BetweenNoiseThresholdProvider> CODEC = RecordCodecBuilder.create(builder -> BetweenNoiseThresholdProvider.method_38439((RecordCodecBuilder.Instance)builder).and(builder.group((App)class_5863.field_29007.listOf().fieldOf("thresholds").forGetter(stateProvider -> stateProvider.thresholds), (App)class_4651.field_24937.fieldOf("within_noise_state_provider").forGetter(stateProvider -> stateProvider.withinNoiseStateProvider), (App)class_4651.field_24937.fieldOf("outside_noise_state_provider").forGetter(stateProvider -> stateProvider.outsideNoiseStateProvider), (App)Codec.BOOL.fieldOf("use_3d_noise").forGetter(stateprovider -> stateprovider.use3D))).apply((Applicative)builder, BetweenNoiseThresholdProvider::new));
    private final List<class_5863> thresholds;
    private final class_4651 withinNoiseStateProvider;
    private final class_4651 outsideNoiseStateProvider;
    private final boolean use3D;

    public BetweenNoiseThresholdProvider(long seed, class_5216.class_5487 noiseParameters, float scale, List<class_5863> thresholds, class_4651 withinNoiseStateProvider, class_4651 outsideNoiseStateProvider, boolean use3D) {
        super(seed, noiseParameters, scale);
        this.thresholds = thresholds;
        this.withinNoiseStateProvider = withinNoiseStateProvider;
        this.outsideNoiseStateProvider = outsideNoiseStateProvider;
        this.use3D = use3D;
    }

    public class_2680 method_23455(Random random, class_2338 pos) {
        double noiseValue = this.use3D ? this.getNoiseValue2D(pos, 4.0) : this.method_38441(pos, this.field_34709);
        for (class_5863 threshold : this.thresholds) {
            if (!(noiseValue >= (double)threshold.method_33915()) || !(noiseValue <= (double)threshold.method_33921())) continue;
            return this.withinNoiseStateProvider.method_23455(random, pos);
        }
        return this.outsideNoiseStateProvider.method_23455(random, pos);
    }

    protected double getNoiseValue2D(class_2338 $$0, double $$1) {
        return this.field_34710.method_27406((double)$$0.method_10263() * $$1, 0.0, (double)$$0.method_10260() * $$1);
    }

    protected class_4652<?> method_28862() {
        return BYGStateProviders.BETWEEN_NOISE_THRESHOLD_PROVIDER.get();
    }

    public static List<class_5863> createThresholds(float size, float min, float max) {
        ArrayList<class_5863> thresholds = new ArrayList<class_5863>();
        for (float start = min; start <= max; start += size * 2.0f) {
            thresholds.add((class_5863)class_5866.method_33934((float)start, (float)(start + size)));
        }
        return thresholds;
    }
}

